package gov.va.vinci.dart.db;

import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.PreparatoryRequest;

/**
 * The Interface PreparatoryRequestDAO.
 */
public interface PreparatoryRequestDAO {

    /**
     * Save.
     *
     * @param request
     *            the request
     */
    void save(final PreparatoryRequest request);

    /**
     * Find by id.
     *
     * @param requestId
     *            the request id
     * @return the preparatory request
     * @throws ObjectNotFoundException
     *             the object not found exception
     */
    PreparatoryRequest findById(final int requestId) throws ObjectNotFoundException;

    /**
     * List by activity id.
     *
     * @param activityId
     *            the activity id
     * @return the list
     */
    List<PreparatoryRequest> listByActivityId(final int activityId);

    /**
     * List by requestor.
     *
     * @param requestorId
     *            the requestor id
     * @return the list
     */
    List<PreparatoryRequest> listByRequestor(final int requestorId);

    /**
     * List all.
     *
     * @return the list
     */
    List<PreparatoryRequest> listAll();

    /**
     * List recent by requestor.
     *
     * @param requestorId
     *            the requestor id
     * @param maxResults
     *            the max results
     * @return the list
     */
    List<PreparatoryRequest> listRecentByRequestor(final int requestorId, final int maxResults);

    /**
     * List by name.
     *
     * @param requestorId
     *            the requestor id
     * @param key
     *            the key
     * @return the list
     */
    List<PreparatoryRequest> listByName(final int requestorId, final String key);

    /**
     * List all but initiated.
     *
     * @return the list
     */
    List<PreparatoryRequest> listAllButInitiated();

    /**
     * List all submitted.
     *
     * @return the list
     */
    List<PreparatoryRequest> listAllSubmitted();

    /**
     * Find most recent amendment.
     *
     * @param headId
     *            the head id
     * @return the preparatory request
     */
    PreparatoryRequest findMostRecentAmendment(final int headId);
}
